/*
 * MusicScript.cs
 * 
 * Holds an array of audio clips used as background music
 * 
 * Created for 2011 Global Game Jam
 */

using UnityEngine;
using System.Collections;

public class MusicScript : MonoBehaviour 
{
    // Inspector Variables
    public AudioClip[] levelMusicFiles = new AudioClip[6];  // Array of aucio clips for backgound music

    // private variables
    int currentPlayingLevel = 0;
     
	// Use this for initialization
	void Start () 
    {
	}
	
	// Update is called once per frame
	void Update () 
    {
        // if the music level tracking matches the level of the game
        if (currentPlayingLevel == Global.generation - 1)
        {
            // if the audio is not playing
            if (!transform.audio.isPlaying)
            {
                currentPlayingLevel = Global.generation - 1;                    // set the audio level flag
                transform.audio.clip = levelMusicFiles[currentPlayingLevel];    // get the clip from the array
                transform.audio.Play();                                         // play the clip
            }
        }
        else
        {
            // if there is an audio file playing
            if (transform.audio.isPlaying)
            {
                transform.audio.Stop();                                         // stop current clip
                currentPlayingLevel = Global.generation - 1;                    // set the audio level flag
                transform.audio.clip = levelMusicFiles[currentPlayingLevel];    // get the clip from the array
                transform.audio.Play();                                         // play the clip
            }
        }
	}
}
