/*
 * Global.cs
 * 
 * Used to contain Global values used throughout the game
 *  
 * Created for 2011 Global Game Jam
 */

using UnityEngine;
using System.Collections;

public class Global : MonoBehaviour 
{
	
	private const float ORIGINAL_SCALE = 10f;
	
	// Static Values
	public static int numOfEachCharacter = 3;       // number of each character to spawn
    public static int generation;                   // the current Generation
    public static int winner;                       // the index of the last character
	public static int currentRound = 0;
    public static int[] numCharsLeft = new int[7];  // Keeps track of how many of each character remain
	
	public static bool gameHasBeenReset;					// flag that tells us if the game has been reset			
	public static bool isTransitioning = false;             // used during the generation transitions
    public static bool[] characterExtinct = new bool[7];    // Keeps track of whether a character is extinct or not

    public static float transitionLerpT = 0f;   // the Lerp for the transition
    public static float transitionLength = 5f;  // the length of the transition
	public static float characterScale = ORIGINAL_SCALE;   // the sclae of the character

    public static GameObject gestureGO; // the gesture object used for generation 6

    // Private Variables
    static float transitionStartTime;   // the time the transition starts
    float scaleIncrement = 5.0f;        // the value to increment the scale by

	// Use this for initialization
	void Start () 
    {
        // persist between levels
		//DontDestroyOnLoad(this);

		numOfEachCharacter = 3;
		currentRound = 0;
		numCharsLeft = new int[7];
		isTransitioning = false;
		characterExtinct = new bool[7];
		transitionLerpT = 0f;
		transitionLength = 5f;
		characterScale = ORIGINAL_SCALE;

        // initialize the generation
        generation = 1;
		
        // intialize the amount of characters
		for(int i = 0; i < 7; i++)
        {
			characterExtinct[i] = false;            // set the extinct flag
			numCharsLeft[i] = numOfEachCharacter;   // set the number of spawns
		}
		
		// since the game is starting we need to disable the gesture object for now
		gestureGO = GameObject.Find("gesture");     // find the gesture object from the hierarchy
		gestureGO.active = false;					// set the gesture active flag to false
	}
	
	// Update is called once per frame
	void Update () 
    {
		// if the game has been reset and we are in the main scene, we ned to deactivate the gesture object.
		if(gameHasBeenReset && (Application.loadedLevelName == "scene1"))
		{
			gestureGO = GameObject.Find("gesture");     // find the gesture object in the Hierarchy
			gestureGO.active = false;					// disable the gesture object
			
			gameHasBeenReset = false;					// game has now finished being reset
		}
			
		// check the transition state to see if the transition is done
        if (transitionLerpT == 1f)
		{
            isTransitioning = false;	// set the flag on the transition
			transitionLerpT = 0;		// reset the counter for the transition
		}

		// if we are transitioning
        if (isTransitioning)
        {
            transitionLerpT = Mathf.Clamp01((Time.time - transitionStartTime) / transitionLength);	// calculate the transition time
			
			// if we are in the 3rd generation or higher we want to scale the characters
			if(generation >= 3)
			{
				// increase the scale of the charaters
				characterScale = ORIGINAL_SCALE + (generation - 3 + transitionLerpT) * scaleIncrement;	
			}
        }
	}
	
	// start a transition from one level to another
	// pass in the value of the character that just went extinct.
    public static void startTransition(int iExtinctChar)
    {
		characterExtinct[iExtinctChar] = true;	// set the extinct flag for the index
        transitionStartTime = Time.time;		// set the start transition time
        isTransitioning = true;					// set the flag to transition
		Camera.main.SendMessage("Transition");	// send the message to the main camera
		
		// if we are in the last level
		if(generation == 6)
			gestureGO.active = true;	// activate the gesture object
		
		CubeSpawner.SpawnNewRound();	// spawn the next round of characters
    }
}
