/*
 * FinalHud.cs
 * 
 * Used to control the GUI buttons on the win screen
 *  
 * Created for 2011 Global Game Jam
 */

using UnityEngine;
using System.Collections;

public class FinalHud : MonoBehaviour 
{
	// Use this for initialization
	void Start () 
	{
	}
	
	// Update is called once per frame
	void Update () 
	{	
	}
	
	// Method for displaying GUI elements to the screen
	void OnGUI()
	{
		// if the GUI button for replay the game is clicked
		if(GUI.Button(new Rect(Screen.width/2-60, Screen.height-75, 120, 20), new GUIContent("Replay the game")))
		{
			//Destroy(GameObject.Find("Global"));	// reset the global values
			Application.LoadLevel(1);			// reload to the main game start
		}
		
		// Figure out if the user is playing via the web.
		bool isWebPlayer = (Application.platform == RuntimePlatform.OSXWebPlayer || Application.platform == RuntimePlatform.WindowsWebPlayer);
		
		// if the player is not playing via the web (AKA standalone)
		if(!isWebPlayer)
		{
			// if the exit button is clicke, quit the game
			if(GUI.Button(new Rect(Screen.width/2-60, Screen.height-50, 120,20), new GUIContent("Exit the Game")))
			{
				Application.Quit();	// quit the game
			}
		}	
	}
}
