/*
 * FinalObjectScript.cs
 * 
 * Used in the WinScene to build the level based on the last
 * remaining character.
 * 
 * Created for 2011 Global Game Jam
 */

using UnityEngine;
using System.Collections;

public class FinalObjectScript : MonoBehaviour 
{
    // Inspector Values

    // Final Materials for the characters
    public Material iPlumberMat;
    public Material sLadyMat;
    public Material benMat;
    public Material eRatMat;
    public Material mDudeMat;
    public Material speedyMat;
    public Material sVulpineMat;

    // Phrases of the Characters
    public string iPlumber = "Congratulations! but your plunger is in another dimension";
    public string sLady = "Great, but it may be invaded by another.";
    public string ben = "Dun nun nun naaaaaaaaaaaaaaaaaaaa";
    public string eRat = "I decided upon you: Electric Rat!";
    public string mDude = "Sorry to take the Joy out of your joystick, Doctor";
    public string speedy = "Remember kids, NEVER climb into a dryer!";
    public string sVulpine = "Not this time Space Vulpine.";
	
	// the audio clips for the voice overs.
    public AudioClip iPlumberVoice;
    public AudioClip sLadyVoice;
    public AudioClip benVoice;
    public AudioClip eRatVoice;
    public AudioClip mDudeVoice;
    public AudioClip speedyVoice;
    public AudioClip sVulpineVoice;

	// Use this for initialization
	void Start () 
    {
        // Determine the winner then Update the texture and the Text
        switch (Global.winner)
        {
            case 1:
                this.renderer.material = iPlumberMat;
                GameObject.Find("iPlumberText").renderer.enabled = true;
                Camera.main.transform.audio.PlayOneShot(iPlumberVoice);
                break;
            case 2:
                this.renderer.material = sLadyMat;
                GameObject.Find("sLadyText").renderer.enabled = true;
                Camera.main.transform.audio.PlayOneShot(sLadyVoice);
                break;
            case 3:
                this.renderer.material = benMat;
                GameObject.Find("benText").renderer.enabled = true;
                Camera.main.transform.audio.PlayOneShot(benVoice);
                break;
            case 4:
                this.renderer.material = eRatMat;
                GameObject.Find("eRatText").renderer.enabled = true;
                Camera.main.transform.audio.PlayOneShot(eRatVoice);
                break;
            case 5:
                this.renderer.material = mDudeMat;
                GameObject.Find("mDudeText").renderer.enabled = true;
                Camera.main.transform.audio.PlayOneShot(mDudeVoice);
                break;
            case 6:
                this.renderer.material = speedyMat;
                GameObject.Find("speedyText").renderer.enabled = true;
                Camera.main.transform.audio.PlayOneShot(speedyVoice);
                break;
            case 7:
                this.renderer.material = sVulpineMat;
                GameObject.Find("sVulpineText").renderer.enabled = true;
                Camera.main.transform.audio.PlayOneShot(sVulpineVoice);
                break;
        }
	}
	
	// Update is called once per frame
	void Update () 
    {	
	}
}
