/*
 * HUD.cs
 * 
 * Mostly used for Debugginng. Tells us which characters
 * are still alive, the preferred character, and the current
 * progression.
 * 
 * Also used to fire sound effects
 * 
 * Created for 2011 Global Game Jam
 */

using UnityEngine;
using System.Collections;

public class HUD : MonoBehaviour 
{
    public AudioClip winVoice;

	// Use this for initialization
	void Start () 
    {
        audio.PlayOneShot(winVoice);
	}
	
	// Update is called once per frame
	void Update () 
    {	
	}

    // called for GUI Updates
    void OnGUI()
    {
        /* UNCOMMENT FOR DEBUGGING PURPOSES
        
        // vertical size of the labels
        int verticalDistance = 20;

        // Display a label for characters remaining
        GUI.Label(new Rect(10, 50, 200, verticalDistance), "Characters Remaining:");

        // The distance to translate for next line
        int yValue = 50 + verticalDistance + 10;

        // loop through the Character Counter Array in the Global
        for (int i = 0; i < Global.numCharsLeft.Length; i++)
        {
            // display where the index is extinct or not
            GUI.Label(new Rect(10, yValue, 100, verticalDistance), "Index " + i + ": " + Global.characterExtinct[i]);
            yValue += verticalDistance + 10;
        }

        // display a label for the current generation
        GUI.Label(new Rect(10, 400, 100, 20), "Generation: " + Global.generation);   */    
    }

    // fire a sound effect from the audio clip passed in
    public void fireSoundEffect(AudioClip ac)
    {
        audio.PlayOneShot(ac);  // play the audio clip
    }
}
