/*
 * Splash.cs
 * 
 * Used to aspects of the splash screen
 *  
 * Created for 2011 Global Game Jam
 */
				
using UnityEngine;
using System.Collections;

public class Splash : MonoBehaviour 
{
	// Inspector Variables
	bool openedPresent = false;			// flag for whether the present has been opened or not
	bool playedTaWah = false;			// flag for if the wha wha sound has been played
	bool userInteracted = false;		// flag for if the user has interacted or now
	
	public Texture oh;					// texture for the image
	
	public AudioClip drumroll;			// drumroll audio clip
	public AudioClip tawah;				// wha wha audio clip

	// Use this for initialization
	void Start () { }
	
	// Update is called once per frame
	void Update () 
	{
		ScaleGUITexture();		// set the scale for the texture
		
		// make sure we are at the splash screen
		if(Application.loadedLevel == 0)
		{
			// set the user interaction flag
			if(Input.anyKey)
				userInteracted = true;
		
			// play the audio if not already
			if(!audio.isPlaying && userInteracted)
			{
				// play the drum roll sound
		        if (!openedPresent && Time.time > 0.1)
				{
					audio.clip = drumroll;	// load the drumroll clip to the audio source
					audio.Play();			// play the clip
					openedPresent = true;	// set the open present flag to false
					//userInteracted = false;	// set the user interaction flag
				}
				// play the wha wha douns
				else if(openedPresent && !playedTaWah)
				{
					guiTexture.texture = oh;	// chage the texture
					audio.clip = tawah;			// load the wha wha audio clip to the audio source
					audio.Play();				// play the clip
					playedTaWah = true;			// set the played wha wha flag
					//userInteracted = false;		// set theuser interaction flag
				}
				// Load the main game if sounds have finished
				else if (openedPresent && playedTaWah)
		            Application.LoadLevel(1);
				
			}
		}
		// reload level if time takes too long
		else
		{
			if (Time.time > 1 && Input.anyKey)
				Application.LoadLevel(0);
		}
	}
	
	// set the scale and location of the background texture
	void ScaleGUITexture()
	{
		// Position the billboard in the center, 
	    // but respect the picture aspect ratio
	    int textureHeight = guiTexture.texture.height;		// get the texture height
	    int textureWidth = guiTexture.texture.width;		// get the texture width
	    int screenHeight = Screen.height;					// get the screen height
	    int screenWidth = Screen.width;						// get the screen width
	
	    int screenAspectRatio = (screenWidth / screenHeight);		// calculate the screen aspect ratio
	    int textureAspectRatio = (textureWidth / textureHeight);	// calculate the texture aspect ratio
	
	    int scaledHeight;	// variable to hold the scaled height
	    int scaledWidth;	// variable to hole the scaled width
		
		// if the texture aspect ratio is less then the screen aspect ratio
	    if (textureAspectRatio <= screenAspectRatio)
	    {
	        // The scaled size is based on the height
	        scaledHeight = screenHeight;
	        scaledWidth = (screenHeight * textureAspectRatio);
	    }
	    else
	    {
	        // The scaled size is based on the width
	        scaledWidth = screenWidth;
	        scaledHeight = (scaledWidth / textureAspectRatio);
	    }
		
		// calculate the location to draw the rectangle
	    float xPosition = screenWidth / 2 - (scaledWidth / 2);
		float yPosition = screenHeight / 2 - (scaledHeight / 2);
		
		// draw the texture to the screen
	    guiTexture.pixelInset = new Rect(xPosition, yPosition, scaledWidth, scaledHeight);
	}
}
